/*  Terminiert die zugehörigen ABKs von den aus der bisherigen Terminierung übernommenen AGe zu Ende.

    Gedacht um im Terminierungs-Migrationsskript nach dem Funktionsaufruf
    "scheduling.resource_timeline__migrate_from_ab2_wkstplan( _timeframe => '2weeks' );" gerufen zu werden.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__finish_termination', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__finish_termination(
) RETURNS void AS $$

  DECLARE

      _prefix varchar := 'scheduling.resource_timeline__finish_termination -';
      _count integer;
      _totalcount integer;
      _ab_record record;
      _ab2_next ab2;
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

      -- Messung Dauer für die Schleifendurchläufe
      _loop_time_begin    timestamp;
      _loop_time_end      timestamp;
      _loop_time_current  interval;
      _loop_time_min      interval;
      _loop_time_max      interval;
      _loop_time_avg      interval;
      _loop_time_total    interval;

      -- Exception-Handling
      _errmsg text;
      _message_text text;
      _pg_exception_context text;
      _pg_exception_detail text;
      _pg_exception_hint text;

  BEGIN

    _count := 0;
    --
    _totalcount := count( a2_ab_ix )
              FROM ab2
             WHERE ( a2_ab_ix, a2_n ) IN ( SELECT a2_ab_ix, max( a2_n )
                                             FROM scheduling.resource_timeline
                                             JOIN ab2 ON a2_id = ti_a2_id
                                            WHERE ti_type IN ( 'task', 'task.buffer' )
                                            GROUP BY a2_ab_ix
                                          )
               AND ( tabk.ab2__next__get( a2_id ) ).a2_id IS NOT NULL;

    FOR _ab_record IN

        SELECT a2_ab_ix, a2_id, a2_n, a2_et
          FROM ab2
         WHERE ( a2_ab_ix, a2_n ) IN ( SELECT a2_ab_ix, max( a2_n )
                                         FROM scheduling.resource_timeline
                                         JOIN ab2 ON a2_id = ti_a2_id
                                        WHERE ti_type IN ( 'task', 'task.buffer' )
                                        GROUP BY a2_ab_ix
                                     )
           AND ( tabk.ab2__next__get( a2_id ) ).a2_id IS NOT NULL
         ORDER BY a2_et, a2_id

    LOOP
        _count := _count + 1;
        _loop_time_begin := clock_timestamp();

        -- Debug
        IF _loglevel >= 4 THEN
            RAISE NOTICE '% [% / %] start abk:%;', _prefix, _count, _totalcount, _ab_record.a2_ab_ix;
        END IF;

        -- Exception-Handling-Block um eventuelle Fehler bei der Terminierung des aktuellen AG abzufangen und danach weiterarbeiten zu können.
        BEGIN

              -- Nachfolger-AG des aktuellen AG ermitteln.
              SELECT n.*
                INTO _ab2_next
                FROM tabk.ab2__next__get( _ab_record.a2_id ) n;
              -- Debug
              IF _loglevel >= 5 THEN
                  RAISE NOTICE '% find next ab2: % (%) -> % (%);', _prefix, _ab_record.a2_n, _ab_record.a2_id, _ab2_next.a2_n, _ab2_next.a2_id;
              END IF;

              PERFORM scheduling.resource_timeline__abk_ab2__termination(
                          _abk_ix                         => _ab_record.a2_ab_ix
                        , _timeframe_start                => _ab_record.a2_et
                        , _timeframe_end                  => _ab_record.a2_et + interval '1 year'
                        , _write_to_disk                  => true
                        , _checkBlockedTimes              => true -- TODO AXS: Was passiert hier bei Auswärts-KSV? Da wird DLZ benötigt.
                        , _termination_range_ab2_id_start => _ab2_next.a2_id
                        , _loglevel                       => _loglevel
                    );

        EXCEPTION
            WHEN OTHERS THEN
                GET STACKED DIAGNOSTICS _message_text = MESSAGE_TEXT
                                      , _pg_exception_detail = PG_EXCEPTION_DETAIL
                                      , _pg_exception_hint = PG_EXCEPTION_HINT
                                      , _pg_exception_context = PG_EXCEPTION_CONTEXT;
                _errmsg :=  'ERROR: ' || _message_text || E'\n' ||
                            'Detail:' || _pg_exception_detail || E'\n' ||
                            'Context:' || _pg_exception_context || E'\n' ||
                            'Hint:' || _pg_exception_hint || E'\n';
                RAISE WARNING '%', _errmsg;
        END;

        -- Messung Dauer für die Schleifendurchläufe
        _loop_time_end := clock_timestamp();
        _loop_time_current := ( _loop_time_end - _loop_time_begin );
        -- Min
        IF _loop_time_min IS null OR _loop_time_min > _loop_time_current  THEN
            _loop_time_min := _loop_time_current;
        END IF;
        -- Max
        IF _loop_time_max IS null OR _loop_time_max < _loop_time_current THEN
            _loop_time_max := _loop_time_current;
        END IF;
        -- Total
        IF _loop_time_total IS null THEN
            _loop_time_total := _loop_time_current;
        ELSE
            _loop_time_total := _loop_time_total + _loop_time_current;
        END IF;
        -- Debug: Duration
        IF _loglevel >= 5 THEN
            RAISE NOTICE '% duration of [abk: %] : %',
                _prefix,
                _ab_record.a2_ab_ix, _loop_time_current;
            -- Debug: Duration Statistics
            RAISE NOTICE '% duration statistics : min:%, avg:%, max:%;',
                _prefix,
                _loop_time_min, ( _loop_time_total / _count ), _loop_time_max;
        END IF;

    END LOOP;

  END $$ LANGUAGE plpgsql;